<?php if ( (bool) get_the_author_meta( 'description' ) && post_type_supports( get_post_type(), 'author' ) ) : ?>
	<div class="author-bio <?php echo get_option( 'show_avatars' ) ? 'show-avatars' : ''; ?>">
		<figure class="image author-image is-96x96 is-pulled-left">
			<?=get_avatar( get_the_author_meta( 'ID' ), 96, '', '', ['class' => 'is-rounded'] )?>
		</figure>
		<div class="author-bio-content">
			<h2 class="author-title">
				<?php
				printf(
				/* translators: %s: Author name. */
					esc_html__( 'By %s', TXTDOMAIN ),
					get_the_author()
				);
				?>
			</h2>
			<p class="author-description"> <?php the_author_meta( 'description' ); ?></p><!-- .author-description -->
			<?php
			printf(
				'<a class="author-link" href="%1$s" rel="author">%2$s</a>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				sprintf(
				/* translators: %s: Author name. */
					esc_html__( 'View all of %s\'s posts.', TXTDOMAIN ),
					get_the_author()
				)
			);
			?>
		</div>
	</div>
<?php endif; ?>
