<?php
$kfvuelzen_unique_in = wp_unique_id('search-form-');
$kfvuelzen_aria_label = !empty($args['aria_label']) ? 'aria-label="'.esc_attr($args['aria_label']).'"' : '';
?>
<form role="search" <?=$kfvuelzen_aria_label?> method="get" class="search-form" action="<?=esc_url(home_url('/'))?>">
    <div class="input-group">
        <span class="input-group-text"><i class="fas fa-search"></i></span>
        <input type="search" id="<?=esc_attr($kfvuelzen_unique_in)?>" class="form-control" value="<?=get_search_query()?>" name="s" placeholder="<?php _e('Search&hellip;', TXTDOMAIN); ?>">
        <button type="submit" class="btn btn-brand"><?=esc_attr_x('Search', 'submit button', TXTDOMAIN)?></button>
    </div>
</form>
