<?php

if (!function_exists('kfvuelzen_comment_form')) {
	function kfvuelzen_comment_form() {
		$req		= get_option( 'require_name_email' );
		$html_req	= ( $req ? ' required="required"' : '' );
		$aria_req	= ($req ? ' aria-required="true"' : '');

		$commenter	= wp_get_current_commenter();

		$comments_arg = [
			'title_reply'           => esc_html__('Leave a comment', TXTDOMAIN),
			'title_reply_before'    => '<h2 id="reply-title" class="comment-reply-title">',
			'title_reply_after'     => '</h2>',
			'fields'                => [
				'author'    => '<div class="mb-3">
									<div class="row">
										<div class="col input-group">
												<span class="input-group-text">
													<i class="fas fa-fw fa-user"></i>
												</span>
												<input id="author" name="author" class="form-control" placeholder="'.__('Name').($req ? ' *' : '').'" type="text" maxlength="100" size="30"'.$aria_req.$html_req.' value="'.$commenter['comment_author'].'">
										</div>
								',
				'email'     => '<div class="input-group col">
                                            <span class="input-group-text">
                                                <i class="fas fa-fw fa-envelope"></i>
                                            </span>
                                            <input id="email" name="email" class="form-control" placeholder="'.__('Email').($req ? ' *' : '').'" type="email" maxlength="100" size="30"'.$aria_req.$html_req.' value="'.$commenter['comment_author_email'].'">
										</div>
									</div>
								</div>',
				'url'       => '<div class="input-group mb-3">
										<span class="input-group-text">
											<i class="fas fa-fw fa-globe"></i>
										</span>
										<input id="url" name="url" class="form-control" placeholder="'.__('Website').'" type="url" maxlength="200" size="30" value="'.$commenter['comment_author_url'].'">
								</div>',
				'cookies'   => '<div class="input-group mb-3">
									<div class="control">
										<label class="checkbox" for="wp-comment-cookies-consent">
											<input type="checkbox" id="wp-comment-cookies-consent" name="wp-comment-cookies-consent">
											' . __( 'Save my name, email, and website in this browser for the next time I comment.' ) . '
										</label>
									</div>
								</div>'
			],

			'comment_field'	=> '<div class="mb-3">
									<label for="comment" class="label">' . __( 'Comment' ) . ' <span class="text-danger"> *</span></label>
									<div class="control">
										<textarea id="comment" class="form-control" name="comment" cols="45" rows="8" maxlength="5000" required="required" aria-required="true"></textarea>
									</div>
								</div>',

			'class_submit'	=> 'btn btn-outline-brand',
			'submit_field'	=> '<div class="d-flex justify-content-center">%1$s %2$s</div>',
			'submit_button'	=> '<button type="submit" id="%2$s" name="%1$s" class="%3$s">
									<span>%4$s</span>
									<span class="icon">
										<i class="fas fa-comment-dots"></i>
									</span>
								</button>'
		];

		comment_form($comments_arg);
	}
}