<?php

class KFVUelzen_DarkMode {

	public function __construct() {
		// Add HTML classes.
		add_filter('kfvuelzen_html_classes', [$this, 'html_classes']);

		// Add the privacy policy content
		add_action('admin_init', [$this, 'add_privacy_policy_content']);

		// Add customizer controls
		add_action('customize_register', [$this, 'customizer_controls']);

		// Add the switch on the fronted & customizer
		add_action('wp_footer', [$this, 'the_switch']);
	}

	public function customizer_controls($wp_customize) {
		$colors_section = $wp_customize->get_section('colors');

		if(is_object($colors_section)) {
			$colors_section->title = __('Colors & Dark Mode', TXTDOMAIN);
		}

		$wp_customize->add_setting('respect_user_color_preference', [
			'capability'        => 'edit_theme_options',
			'default'           => false,
			'sanitize_callback' => [KFVUelzen_Customize::class, 'sanitize_checkbox']
		]);

		$description = '<p>';
		$description .= __('Dark Mode is a device setting. If a visitor to your site requests it, your site will be shown witch a dark background and light text.', TXTDOMAIN);
		$description .= '</p>';
		$description .= '<p>';
		$description .= __('Dark Mode can also be turned on and off with a button that you can find in the buttom corner of the page.', TXTDOMAIN);
		$description .= '</p>';

		$wp_customize->add_control('respect_user_color_preference', [
			'type'              => 'checkbox',
			'section'           => 'colors',
			'label'             => esc_html__('Dark Mode support', TXTDOMAIN),
			'priority'          => 110,
			'description'       => $description,
		]);

		$wp_customize->selective_refresh->add_partial('background_color', [
			'selector'              => '#darkmode-toggler',
			'container_inclusive'   => true,
			'render_callback'       => function() {
				$attrs = ($this->switch_should_render()) ? [] : ['style' => 'display: none;'];
				$this->the_html($attrs);
			}
		]);
	}

	public function html_classes($classes) {
		if (!$this->switch_should_render()) {
			return $classes;
		}

		$should_respect_color_scheme = get_theme_mod('respect_user_color_preference', false);
		if ($should_respect_color_scheme) {
			return ($classes) ? ' respect-color-scheme-preference' : 'respect-color-scheme-preference';
		}

		return $classes;
	}

	public function switch_should_render() {
		global $is_IE;

		return (
			get_theme_mod('respect_user_color_preference', false) && !$is_IE
		);
	}

	public function the_switch() {
		if(!$this->switch_should_render()) {
			return;
		}

		$this->the_html();
		//$this->the_script();
	}

	public function the_html($attrs = []) {
		$attrs = wp_parse_args($attrs, [
			'id'            => 'darkmode-toggler',
			'class'         => 'darkmode-toggler',
			'aria-pressed'  => 'false'
		]);

		echo '<button';
		foreach($attrs as $key => $val) {
			echo ' '.esc_attr($key).'="'.esc_attr($val).'"';
		}
		echo '><i class="fas fa-fw fa-moon fa-2x" style="display: none;"></i> <i class="fas fa-fw fa-sun fa-2x"></i></button>';
	}
/*
	public function the_script() {
		echo '<script>';
		include get_template_directory().'/assets/js/darkmode.js';
		echo '</script>';
	}
*/
	public function add_privacy_policy_content() {
		if (!function_exists('wp_add_privacy_policy_content')) {
			return;
		}

		$content = '<p class="privacy-policy-tutorial">'.__('KFVUelzen Theme uses LocalStorage when Dark Mode support is enabled.', TXTDOMAIN).'</p>'
			. '<strong class="privacy-policy-tutorial">'.__('Suggested text:', TXTDOMAIN).'</strong> '
			. __('This website uses LocalStorage to save the setting when Dark Mode support is turned on or off.<br>LocalStorage is necessary for the setting to work and is only used when a user clicks on the Dark Mode button.<br>No data is saved in the database or transferred.', TXTDOMAIN);

		wp_add_privacy_policy_content('KFVUelzen Theme', wp_kses_post(wpautop($content, false)));
	}
}