<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">

	<?php wp_head(); ?>
    <?php echo vite(['resources/css/app.scss', 'resources/js/app.js']); ?>
</head>
<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>

	<div class="head" id="head-container">
		<div class="container header content mx-auto py-12" id="head-container">
			<?php get_template_part('views/header/site-branding'); ?>
		</div>

		<nav class="navbar navbar-expand-lg" role="navigation" aria-label="main navigation" id="navbar-main">
            <div class="container">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-main-content" aria-controls="navbar-main-content" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

				<div id="navbar-main-content" class="collapse navbar-collapse">
					<?php kfvuelzen_navbar_main(); ?>

					<div class="navbar-start navbar-search d-none" id="navbar-main-search">
						<form method="get" role="search" action="<?=home_url('/')?>">
							<input class="input" name="s" type="search" id="navbar-main-search-input" placeholder="<?=__('Search...', TXTDOMAIN)?>">

							<!--<span class="icon" id="navbar-main-search-clear">
                                <i class="fas fa-times"></i>
                            </span>-->
						</form>
					</div>

					<div class="navbar-end">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a href="#" class="nav-link navbar-link-search" id="navbar-main-search-toggle">
                                    <i class="fas fa-search" id="navbar-search-icon-search"></i>
                                    <i class="fas fa-times d-none" id="navbar-search-icon-times"></i>
                                </a>
                            </li>
                        </ul>
					</div>
				</div>
			</div>


			<div id="navbar-main-content-mobile" class="navbar-menu is-hidden-desktop" style="display: none;">
				<?php kfvuelzen_navbar_main(true); ?>

				<div class="navbar-end">
					<form method="get" role="search" action="<?=home_url('/')?>">
						<div class="field has-addons is-justify-content-center">
							<div class="control">
								<input class="input" name="s" type="search" id="navbar-main-mobile-search-input" placeholder="<?=__('Search...', TXTDOMAIN)?>">
							</div>
							<div class="control">
								<button type="submit" class="button is-light">
									<i class="fas fa-search"></i>
								</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</nav>
	</div>

	<div class="content-wrapper">
		<div id="content" class="site-content row">
