<?php
if (post_password_required()) {
	return;
}

$kfvuelzen_comment_count = get_comments_number();
?>
<div id="comments" class="comments-area">
	<?php
		kfvuelzen_comment_form();
	?>

	<?php if (have_comments()): ?>
		<h2 class="comments-title">
			<?php
				printf(
					/* translators: %s: Comment count number */
					esc_html(_nx('%s comment', '%s comments', $kfvuelzen_comment_count, 'Comments title', TXTDOMAIN)),
					esc_html(number_format_i18n($kfvuelzen_comment_count))
				);
			?>
		</h2>
		<ol class="comment-list">
			<?php
				wp_list_comments([
					'walker'		=> new KFVUelzen_Comment_Walker(),
					'avatar_size'   => 64,
					'style'         => 'div',
					'short_ping'    => true
				]);
			?>
		</ol>

		<?php kfvuelzen_the_comments_pagination(); ?>

		<?php if(!comments_open()): ?>
			<p class="no-comments"><?php esc_html_e('Comments are closed', TXTDOMAIN); ?></p>
		<?php endif; ?>
	<?php endif; ?>
</div>
