<?php get_header(); ?>

<?php get_sidebar('left'); ?>

<main id="main" class="site-main col-12 col-lg-7 order-first order-lg-2">
	<?php
		while(have_posts()) {
			the_post();

			get_template_part('views/content/content-single');

			if ( is_attachment() ) {
				// Parent post navigation.
				the_post_navigation(
					array(
						/* translators: %s: Parent post link. */
						'prev_text' => sprintf( __( '<span class="meta-nav">Published in</span><span class="post-title">%s</span>', 'twentytwentyone' ), '%title' ),
					)
				);
			}

			// If comments are open or there is at least on comment, load up the comment template
			if (comments_open() || get_comments_number()) {
				comments_template();
			}

			// Previous/next post navigation.
			$kfvuelzen_next = is_rtl() ? '<i class="fas fa-angle-left"></i>' : '<i class="fas fa-angle-right"></i>';
			$kfvuelzen_prev = is_rtl() ? '<i class="fas fa-angle-right"></i>' : '<i class="fas fa-angle-left"></i>';

			$kfvuelzen_next_label     = esc_html__( 'Next post', TXTDOMAIN );
			$kfvuelzen_previous_label = esc_html__( 'Previous post', TXTDOMAIN );

			the_post_navigation(
				array(
					'next_text' => '<p class="meta-nav">' . $kfvuelzen_next_label . $kfvuelzen_next . '</p><p class="post-title">%title</p>',
					'prev_text' => '<p class="meta-nav">' . $kfvuelzen_prev . $kfvuelzen_previous_label . '</p><p class="post-title">%title</p>',
				)
			);
		}
	?>
</main>

<?php get_sidebar('right'); ?>

<?php get_footer();
