<?php

class KFVUelzen_Comment_Walker extends Walker_Comment {

	protected function html5_comment( $comment, $depth, $args ) {
		$tag = ($args['style'] === 'div') ? 'div' : 'li';

		$output = [];

		$commenter = wp_get_current_commenter();
		$show_pending_links = !empty($commenter['comment_author']);

		if ($commenter['comment_author_email']) {
			$moderation_note = __('Your comment is awaiting moderation.');
		} else {
			$moderation_note = __('Your comment is awaiting moderation. This is a preview; your comment will be visible after it has been approved');
		}

		?>
		<<?=$tag?> id="comment-<?php comment_ID(); ?>" <?php comment_class($this->has_children ? 'parent' : '', $comment); ?>>
			<article id="div-comment-<?php comment_ID(); ?>" class="comment-body d-flex">
				<figure class="flex-shrink-0">
					<?php
					if ($args['avatar_size'] != 0) {
						echo get_avatar($comment, $args['avatar_size'], '', '', ['class' => 'image is-'.$args['avatar_size'].'x'.$args['avatar_size']]);
					}
					?>
				</figure>
				<div class="media-content flex-grow-1">
					<header class="comment-meta">
						<div class="comment-author vcard">
							<?php
							$comment_author = get_comment_author_link($comment);

							if ($comment->comment_approved == '0' && !$show_pending_links) {
								$comment_author = get_comment_author($comment);
							}

							printf(
								__('%s <span class="says">says:</span>'),
								sprintf('<b class="fn">%s</b>', $comment_author)
							);
							?>
						</div>

						<div class="comment-metadata">
							<?php
							printf(
								'<a href="%s"><time datetime="%s">%s</time></a>',
								esc_url(get_comment_link($comment, $args)),
								get_comment_time('c'),
								sprintf(
								/** translators: 1: comment date, 2: comment time */
									__('%1$s at %2$s'),
									get_comment_date('', $comment),
									get_comment_time()
								)
							);
							?>
						</div>
					</header>


					<?php
					if ($comment->comment_approved == '0') {
						echo '<em class="comment-awaiting-moderation">'.$moderation_note.'</em>';
					}
					?>

					<div class="comment-content">
						<?php comment_text(); ?>
					</div>

					<footer class="comment-meta comment-footer">
						<?php
						edit_comment_link(__('Edit'), ' <span class="edit-link"><i class="fas fa-edit"></i> ', '</span>');

						if ($comment->comment_approved == '1' || $show_pending_links) {
							comment_reply_link(array_merge($args,  [
								'add_below'     => 'div-comment',
								'depth'         => $depth,
								'max_depth'     => $args['max_depth'],
								'before'        => '<div class="reply">',
								'after'         => '</div>',
								'reply_text'    => __('Reply').' <i class="fas fa-reply"></i>'
							]));
						}
						?>
					</footer>
				</div>
			</article>

	<?php
	}
}