<?php

if ( ! function_exists( 'kfvuelzen_posted_on' ) ) {
	function kfvuelzen_posted_on() {
		$timestring = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

		$timestring = sprintf(
			$timestring,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() )
		);

		printf(
			'<span class="posted-on"><i class="fas fa-calendar fa-fw"></i> <a href="%1$s" rel="bookmark">%2$s</a></span>',
			esc_url( get_permalink() ),
			$timestring
		);
	}
}

if ( ! function_exists( 'kfvuelzen_posted_by' ) ) {
	function kfvuelzen_posted_by() {
		if ( ! get_the_author_meta( 'description' ) && post_type_supports( get_post_type(), 'author' ) ) {
			printf(
				'<span class="byline"><i class="fas fa-user fa-fw"></i> <a href="%1$s" rel="author">%2$s</a></span>',
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				esc_html( get_the_author() )
			);
		}
	}
}

if ( ! function_exists( 'kfvuelzen_entry_meta_footer' ) ) {
	function kfvuelzen_entry_meta_footer() {
		if ( get_post_type() !== 'post' ) {
			return;
		}

		if ( ! is_single() ) {
			$post_format = get_post_format();
			if ( $post_format === 'aside' || $post_format === 'status' ) {
				echo '<p><a href="' . esc_url( get_permalink() ) . '">' . kfvuelzen_continue_reading_text() . '</a></p>';
			}

			kfvuelzen_cat_tags_list( true );
		} else {
			kfvuelzen_cat_tags_list( true );
		}
	}
}

if ( ! function_exists( 'kfvuelzen_entry_meta_header' ) ) {
	function kfvuelzen_entry_meta_header() {
		if ( get_post_type() !== 'post' ) {
			return;
		}

		if ( ! is_single() ) {
			$post_format = get_post_format();
			if ( $post_format === 'aside' || $post_format === 'status' ) {
				echo '<p><a href="' . esc_url( get_permalink() ) . '">' . kfvuelzen_continue_reading_text() . '</a></p>';
			}

			echo '<div class="posted-by">';
			kfvuelzen_posted_by();
			kfvuelzen_posted_on();
			kfvuelzen_edit_link();
			echo '</div>';
		} else {
			echo '<div class="posted-by">';
			kfvuelzen_posted_by();
			kfvuelzen_posted_on();
			kfvuelzen_edit_link();
			echo '</div>';
		}
	}
}

if ( ! function_exists( 'kfvuelzen_edit_link' ) ) {
	function kfvuelzen_edit_link() {
		edit_post_link(
			__( 'Edit', TXTDOMAIN ),
			'<span class="edit-link"><i class="fas fa-fw fa-edit"></i> ',
			'</span>'
		);
	}
}

if ( ! function_exists( 'kfvuelzen_cat_tags_list' ) ) {
	function kfvuelzen_cat_tags_list( $only_tags = false, $only_cats = false ) {
		if ( has_category() || has_tag() ) {
			echo '<div class="post-taxonomies">';

			$categories_list = get_the_category_list(', ');
			if ( $categories_list && ! $only_tags ) {
				printf(
					'<span class="cat-links">%s</span>',
					$categories_list
				);
			}

			$tags_list = get_the_tag_list( '', ', ');
			if ( $tags_list && ! $only_cats ) {
				printf(
					'<span class="tag-links"><i class="fas fa-tags"></i> %s</span>',
					$tags_list
				);
			}

			echo '</div>';
		}
	}
}

if ( ! function_exists( 'kfvuelzen_post_thumbnail' ) ) {
	function kfvuelzen_post_thumbnail() {
		if ( ! kfvuelzen_can_show_post_thumbnail() ) {
			return;
		}

		if ( is_singular() ): ?>
		<a href="<?=get_the_post_thumbnail_url()?>" data-lightbox="post-thumbnail">
			<figure class="post-thumbnail">
				<?php the_post_thumbnail( 'post-thumbnail', [ 'loading' => false ] ); ?>
				<?php if ( wp_get_attachment_caption( get_post_thumbnail_id() ) ) : ?>
					<figcaption class="wp-caption-text">
						<?php echo wp_kses_post( wp_get_attachment_caption( get_post_thumbnail_id() ) ); ?>
					</figcaption>
				<?php endif; ?>
			</figure>
		</a>
		<?php else : ?>
			<figure class="post-thumbnail">
				<a class="post-thumbnail-inner" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
					<?php the_post_thumbnail( 'post-thumbnail' ); ?>
				</a>
				<?php if ( wp_get_attachment_caption( get_post_thumbnail_id() ) ) : ?>
					<figcaption class="wp-caption-text">
						<?php echo wp_kses_post( wp_get_attachment_caption( get_post_thumbnail_id() ) ); ?>
					</figcaption>
				<?php endif; ?>
			</figure>
		<?php
		endif;
	}
}

if ( ! function_exists( 'kfvuelzen_the_posts_navigation' ) ) {
	function kfvuelzen_the_posts_navigation($echo = true, $params = []) {
		$pages       = paginate_links( [
			'type'      => 'array',
			'show_all'	=> false,
			'end_size'	=> 1,
			'mid_size'	=> 1,
			'prev_next' => false,
			'prev_text' => __( 'Previous', TXTDOMAIN),
			'next_text' => __( 'Next', TXTDOMAIN),
		] );

		$total_pages = count($pages);

		if ( is_array( $pages ) ) {
			// Get current page
			$paged = ( get_query_var( 'paged' ) == 0 ) ? 1 : get_query_var( 'paged' );

			$pagination = '<nav role="navigation" aria-label="navigation"><ul class="pagination justify-content-center">';

			//Disable Previous button if the current page is the first one
			if ( $paged == 1 ) {
				$pagination .= sprintf('<li class="page-item disabled"><a class="page-link pagination-previous"><i class="fas fa-angle-left fa-fw"></i> %s</a></li>', __('Previous', TXTDOMAIN));
			} else {
				$pagination .= sprintf('<li class="page-item"><a class="page-link pagination-previous" href="%s"><i class="fas fa-angle-left fa-fw"></i> %s</a></li>', get_previous_posts_page_link(), __('Previous', TXTDOMAIN));
			}

			foreach($pages as $page) {
				$pagination .= '<li class="page-item">'.str_replace('page-numbers', 'page-link', str_replace( 'current', 'active', $page )).'</li>';
			}

            //Disable Next button if the current page is the last one
            if ( $paged < $total_pages ) {
                $pagination .= sprintf('<li class="page-item"><a class="page-link pagination-next" href="%s">%s <i class="fas fa-angle-right fa-fw"></i></a></li>', get_next_posts_page_link(), __('Next', TXTDOMAIN));
            } else {
                $pagination .= sprintf('<li class="page-item disabled"><a class="page-link pagination-next">%s <i class="fas fa-angle-right fa-fw"></i></a></li>', __('Next', TXTDOMAIN));
            }

			echo '</ul></nav>';

			if ( $echo ) {
				echo $pagination;
			} else {
				return $pagination;
			}
		}

		return null;
	}
}

if ( ! function_exists( 'kfvuelzen_the_comments_pagination' ) ) {
	function kfvuelzen_the_comments_pagination($echo = true) {
		global $wp_query;

		if ( empty( $max_page ) ) {
			$max_page = $wp_query->max_num_comment_pages;
		}

		if ( empty( $max_page ) ) {
			$max_page = get_comment_pages_count();
		}

		$page = get_query_var( 'cpage' );

		if ( ! $page ) {
			$page = 1;
		}

		$nextpage = (int) $page + 1;
		$prevpage = (int) $page - 1;

		$pages       = paginate_comments_links( [
			'type'      => 'array',
			'show_all'	=> false,
			'end_size'	=> 1,
			'mid_size'	=> 1,
			'prev_next' => false,
			'prev_text' => __( 'Older comments', TXTDOMAIN ),
			'next_text' => __( 'Newer comments', TXTDOMAIN),
		] );

		if ( is_array( $pages ) ) {

            $total_pages = count($pages);
			// Get current page
			$paged = ( get_query_var( 'cpage' ) == 0 ) ? 1 : get_query_var( 'cpage' );

			$pagination = '<nav role="navigation" aria-label="navigation"><ul class="pagination justify-content-center">';

			//Disable Previous button if the current page is the first one
			if ( $paged == 1 ) {
				$pagination .= sprintf('<li class="page-item disabled"><a class="page-link pagination-previous"><i class="fas fa-angle-left fa-fw"></i> %s</a></li>', __('Older comments', TXTDOMAIN));
			} else {
				$pagination .= sprintf('<li class="page-item"><a class="page-link pagination-previous" href="%s"><i class="fas fa-angle-left fa-fw"></i> %s</a></li>', esc_url( get_comments_pagenum_link( $prevpage ) ) , __('Older comments', TXTDOMAIN));
			}

			foreach($pages as $page) {
				$pagination .= '<li class="page-item">'.str_replace('page-numbers', 'page-link', str_replace( 'current', 'active', $page )).'</li>';
			}

            //Disable Next button if the current page is the last one
            if ( $paged < $total_pages ) {
                $pagination .= sprintf('<li class="page-item"><a class="page-link pagination-next" href="%s">%s <i class="fas fa-angle-right fa-fw"></i></a></li>', esc_url(get_comments_pagenum_link($nextpage, $max_page)), __('Newer comments', TXTDOMAIN));
            } else {
                $pagination .= sprintf('<li class="page-item disabled"><a class="page-link pagination-next">%s <i class="fas fa-angle-right fa-fw"></i></a></li>', __('Newer comments', TXTDOMAIN));
            }

			echo '</ul></nav>';

			if ( $echo ) {
				echo $pagination;
			} else {
				return $pagination;
			}
		}

		return null;
	}
}