<?php

if (!function_exists('kfvuelzen_continue_reading_text')) {
	function kfvuelzen_continue_reading_text() {
		return sprintf(
			/* translators: %s is angle right */
			esc_html__('Continue reading %s', TXTDOMAIN),
			'<i class="fas fa-angle-right"></i>'
		);
	}
}

if(!function_exists('kfvuelzen_can_show_post_thumbnail')) {
	function kfvuelzen_can_show_post_thumbnail() {
		return apply_filters(
			'kfvuelzen_can_show_post_thumbnail',
			!post_password_required() && !is_attachment() && has_post_thumbnail()
		);
	}
}

if(!function_exists('kfvuelzen_print_first_instance_of_block')) {
	function kfvuelzen_print_first_instance_of_block($block_name, $content = null, $instances = 1) {
		$instances_count = 0;
		$blocks_content = '';

		if(!$content) {
			$content = get_the_content();
		}

		// Parse blocks in the element
		$blocks = parse_blocks($content);

		// Loop blocks
		foreach ($blocks as $block) {
			// Sanity check
			if (!isset($block['blockName'])) {
				continue;
			}

			// Check if this the block matches the $block_name
			$is_matching_block = false;

			// If the block ends with *, try to match the first portion
			if ('*' === $block_name[-1]) {
				$is_matching_block = 0 === strpos( $block['blockName'], rtrim( $block_name, '*' ) );
			} else {
				$is_matching_block = $block_name === $block['blockName'];
			}

			if($is_matching_block) {
				// Increment count
				$instances_count++;

				// Add the block HTML
				$blocks_content .= render_block($block);

				// Break the loop if the $instances count was reached
				if ($instances_count >= $instances) {
					break;
				}
			}
		}

		if($blocks_content) {
			echo apply_filters('the_content', $blocks_content);
			return true;
		}

		return false;
	}
}