<?php

class KFVUelzen_Customize {
	public function __construct() {
		add_action('customize_register', [$this, 'register']);
	}

	public function register($wp_customize) {
		// Change site-title & description to postMessage
		$wp_customize->get_setting('blogname')->transport = 'postMessage';
		$wp_customize->get_setting('blogdescription')->transport = 'postMessage';

		// Add partial for blogname
		$wp_customize->selective_refresh->add_partial('blogname', [
			'selector'          => '.site-title',
			'render_callback'   => [$this, 'partial_blogname']
		]);

		// Add partial for blogdescription
		$wp_customize->selective_refresh->add_partial('blogdescription', [
			'selector'          => '.site-description',
			'render_callback'   => [$this, 'partial_blogdedescription']
		]);

		// Add "display_title_and_tagline" setting for displaying the site-title & tagline
		$wp_customize->add_setting('display_title_and_tagline', [
			'capability'            => 'edit_theme_options',
			'default'               => true,
			'sanitize_callback'     => [__CLASS__, 'sanitize_checkbox']
		]);

		// Add control for the "display_title_and_tagline" setting
		$wp_customize->add_control('display_title_and_tagline', [
			'type'      => 'checkbox',
			'section'   => 'title_tagline',
			'label'     => esc_html__('Display Site Title & Tagline', TXTDOMAIN)
		]);

		/**
		 * Add excerpt or full text selector to customizer
		 */
		$wp_customize->add_section('excerpt_settings', [
			'title'     => esc_html__('Excerpt Settings', TXTDOMAIN),
			'priority'  => 120
		]);

		$wp_customize->add_setting('display_excerpt_or_full_post', [
			'capabilitiy'       => 'edit_theme_options',
			'default'           => 'excerpt',
			'sanitize_callback' => static function ($value) {
				return 'excerpt' === $value || 'full' === $value ? $value : 'excerpt';
			}
		]);

		$wp_customize->add_control('display_excerpt_or_full_post', [
			'type'          => 'radio',
			'section'       => 'excerpt_settings',
			'label'         => esc_html__('On Archive Pages, posts show:', TXTDOMAIN),
			'choices'       => [
				'excerpt'       => esc_html__('Summary', TXTDOMAIN),
				'full'          => esc_html__('Full text', TXTDOMAIN)
			]
		]);
	}

	public function partial_blogname() {
		bloginfo('name');
	}

	public function partial_blogdescription() {
		bloginfo('description');
	}

	public static function sanitize_checkbox( $checked = null ) {
		return (bool) isset( $checked ) && true === $checked;
	}
}