<?php
get_header();

$description = get_the_archive_description();
?>

<?php get_sidebar('left'); ?>

<main id="main" class="site-main col-12 col-lg-7">
	<?php if(have_posts()): ?>
		<header class="page-header alignwide">
			<?php the_archive_title('<h1 class="page-title">', '</h1>'); ?>
			<?php if($description): ?>
				<div class="archive-description"><?= wp_kses_post(wpautop($description)) ?></div>
			<?php endif; ?>
		</header><!-- .page-header -->

		<?php
			while(have_posts()) {
				the_post();

				get_template_part('views/content/content', get_theme_mod( 'display_excerpt_or_full_post', 'excerpt' ));
			}

			kfvuelzen_the_posts_navigation();
		?>

	<?php else: ?>
		<?php get_template_part('views/content/content', 'none'); ?>
	<?php endif; ?>
</main>

<?php get_sidebar('right'); ?>

<?php get_footer(); ?>
