<?php

function kfvuelzen_post_classes($classes) {
	$classes[] = 'entry';

	return $classes;
}
add_filter('post_class', 'kfvuelzen_post_classes');

function kfvuelzen_pingback_header() {
	if (is_singular() && pings_open()) {
		echo '<link rel="pingback" href="', esc_url(get_bloginfo('pingback_url')), '">';
	}
}
add_action('wp_head', 'kfvuelzen_pingback_header');

function kfvuelzen_continue_reading_link_excerpt() {
	return '&hellip; <div class="more-link-container"><a class="button more-link" href="'.esc_url(get_permalink()).'">'.kfvuelzen_continue_reading_text().'</a></div>';
}
add_filter('excerpt_more', 'kfvuelzen_continue_reading_link_excerpt');

function kfvuelzen_continue_reading_link() {
	return '<div class="more-link-container"><a class="more-link" href="'.esc_url(get_permalink()).'#more-'.esc_attr(get_the_ID()).'">'.kfvuelzen_continue_reading_text().'</a></div>';
}
add_filter('the_content_more_link', 'kfvuelzen_continue_reading_link');