<?php
const TXTDOMAIN = 'kfvuelzen';
const KFVUELZEN_YEAR = 2022;
const KFVUELZEN_VERSION = "2.0.2";

const KFVUELZEN_AUTHOR = 'K. Preuss';
const KFVUELZEN_AUTHOR_URL = 'https://kpreuss.de';

require_once get_template_directory().'/inc/vite.php';
require_once get_template_directory().'/inc/extras.php';
require_once get_template_directory().'/inc/template-tags.php';
require_once get_template_directory().'/inc/template-functions.php';
require_once get_template_directory().'/inc/template-filters.php';

require_once get_template_directory().'/inc/walker/navwalker.php';
require_once get_template_directory().'/inc/walker/commentwalker.php';

require_once get_template_directory().'/inc/customizer/KFVUelzen_Customize.php';
require_once get_template_directory().'/inc/customizer/KFVUelzen_DarkMode.php';

/*
 * Load custom widgets
 */
require get_template_directory().'/inc/widgets/archives.php';

new KFVUelzen_Customize();
new KFVUelzen_DarkMode();

$vite = new Vite();

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false', 100 );

// Disables the block editor from managing widgets. renamed from wp_use_widgets_block_editor
add_filter( 'use_widgets_block_editor', '__return_false' );

if(!function_exists('kfvuelzen_setup')) {
	function kfvuelzen_setup() {
		/**
		 * Make theme available for translation
		 */
		load_theme_textdomain(TXTDOMAIN, get_template_directory().'/languages');

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * This theme does not use a hard-coded <title> tag in the document head,
		 * WordPress will provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/**
		 * Add post-formats support.
		 */
		add_theme_support(
			'post-formats',
			[
				'link',
				'aside',
				'image',
				'quote',
				'audio',
			]
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			[
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
				'navigation-widgets',
			]
		);

		/*
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		$logo_width  = 300;
		$logo_height = 100;

		add_theme_support(
			'custom-logo',
			array(
				'height'               => $logo_height,
				'width'                => $logo_width,
				'flex-width'           => true,
				'flex-height'          => true,
				'unlink-homepage-logo' => true,
			)
		);

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 1568, 882, true );

		add_image_size('kfvuelzen-featured-image', 1920, 1080, true);
		add_image_size('kfvuelzen-post-image', 1080, 195, true);

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Load default block styles.
		//add_theme_support('wp-block-styles');

		// Add support for responsive embeds.
		add_theme_support('responsive-embeds');

		register_nav_menus([
			'primary'   => __('Main Menu', TXTDOMAIN),
			'footer'    => __('Footer Menu', TXTDOMAIN),
		]);

		// Remove wordpress version tag
		remove_action('wp_head', 'wp_generator');

		// Remove feed icon link from legacy RSS widget.
		add_filter( 'rss_widget_feed_link', '__return_false' );
	}
}
add_action('after_setup_theme', 'kfvuelzen_setup');

if(!function_exists('kfvuelzen_scripts')) {
	function kfvuelzen_scripts() {
		wp_enqueue_script('jquery');
	}
}
add_action('wp_enqueue_scripts', 'kfvuelzen_scripts');

if(!function_exists('kfvuelzen_widgets_init')) {
	function kfvuelzen_widgets_init() {
		register_sidebar([
			'id'			=> 'sidebar-left',
			'name'			=> __('Left Sidebar', TXTDOMAIN),
			'description'	=> __('Add widgets here to appear in your sidebar on blog posts and archive pages.', TXTDOMAIN),
			'before_widget'	=> '<section id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</section>',
			'before_title'	=> '<h4 class="widget-title">',
			'after_title'	=> '</h4>'
		]);

		register_sidebar([
			'id'			=> 'sidebar-right',
			'name'			=> __('Right Sidebar', TXTDOMAIN),
			'description'	=> __('Add widgets here to appear in your sidebar on blog posts and archive pages.', TXTDOMAIN),
			'before_widget'	=> '<section id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</section>',
			'before_title'	=> '<h4 class="widget-title">',
			'after_title'	=> '</h4>'
		]);


		register_widget( 'KFVUelzen_Widget_Archives' );
	}
}
add_action('widgets_init', 'kfvuelzen_widgets_init');

if(!function_exists('kfvuelzen_navbar_main')) {
	function kfvuelzen_navbar_main($mobile = false) {
		wp_nav_menu([
			'theme_location'        => 'primary',
			'depth'                 => 4,
			'container'             => false,
			'menu_class'            => '',
            'menu_id'               => 'navbar-main-menu',
			'items_wrap'            => '<ul id="%1$s" class="navbar-nav me-auto mb-2 mb-md-0 %2$s">%3$s</ul>',
			'walker'                => new Bootstrap_Navwalker(),
			'fallback_cb'           => 'Bootstrap_Navwalker::fallback'
		]);
	}
}

if (!function_exists('kfvuelzen_copyright')) {
	function kfvuelzen_copyright() {
		if(intval(KFVUELZEN_YEAR) < date('Y')) $year = intval(KFVUELZEN_YEAR).'-'.date('Y');
		else $year = intval(KFVUELZEN_YEAR);

		printf('Copyright &copy; %s %s', $year, get_bloginfo('name', 'display'));
	}
}

if (!function_exists('kfvuelzen_author')) {
	function kfvuelzen_author() {
		printf('Designed by <a href="%s">%s</a>', KFVUELZEN_AUTHOR_URL, KFVUELZEN_AUTHOR);
	}
}
