<?php
$blog_info      = get_bloginfo('name');
$description    = get_bloginfo('description', 'display');
$show_title     = (true === get_theme_mod('display_title_and_tagline', true));
$header_class   = $show_title ? 'site-title' : 'screen-reader-text';
?>

<?php if(has_custom_logo() && $show_title): ?>
	<div class="site-logo"><?php the_custom_logo(); ?></div>
<?php endif; ?>

<div class="site-branding">
	<?php if(has_custom_logo() && !$show_title) : ?>
		<div class="site-logo"><?php the_custom_logo(); ?></div>
	<?php endif; ?>

	<?php if($blog_info): ?>
		<?php if(is_front_page() && !is_paged()): ?>
			<h1 class="<?= esc_attr($header_class) ?>"><?= esc_html($blog_info) ?></h1>
		<?php else: ?>
			<h1 class="<?= esc_attr($header_class) ?>"><a href="<?=esc_url(home_url('/'))?>"><?= esc_html($blog_info) ?></a></h1>
		<?php endif; ?>
	<?php endif; ?>

	<?php if($description && $show_title) : ?>
		<p class="site-description">
			<?=$description?>
		</p>
	<?php endif; ?>
</div>
