<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php kfvuelzen_cat_tags_list(false, true); ?>

		<?php if(is_singular()) : ?>
			<?php the_title('<h1 class="entry-title">', '</h1>'); ?>
		<?php else : ?>
			<?php the_title(sprintf('<h2 class="entry-title"><a href="%s">', esc_url(get_permalink())), '</a></h2>'); ?>
		<?php endif; ?>

		<?php if(is_sticky() && is_home() && !is_paged()) : ?>
		<div class="sticky-icon">
			<i class="fas fa-2x fa-thumbtack"></i>
		</div>
		<?php endif; ?>

		<?php kfvuelzen_entry_meta_header(); ?>

		<?php kfvuelzen_post_thumbnail(); ?>
	</header>

	<div class="entry-content">
		<?php
		the_content(
			kfvuelzen_continue_reading_text()
		);

		wp_link_pages(
			array(
				'before'   => '<nav class="page-links" aria-label="' . esc_attr__( 'Page', 'twentytwentyone' ) . '">',
				'after'    => '</nav>',
				/* translators: %: Page number. */
				'pagelink' => esc_html__( 'Page %', 'twentytwentyone' ),
			)
		);
		?>
	</div>

	<footer class="entry-footer">
		<?php kfvuelzen_entry_meta_footer(); ?>
	</footer>
</article>