<article <?php post_class(); ?> id="post-<?=get_the_ID()?>">
	<header class="hentry-header">
		<?php
			if(get_post_type() === 'post' && is_singular()) {
				echo '<div class="hentry-meta">';
					fwuelzen_entry_header();
				echo '</div>';
			}

			if(is_singular())
				the_title('<h1 class="hentry-title">', '</h1>');
			elseif(is_front_page() && is_home())
				the_title(sprintf('<a href="%s" rel="bookmark"><h3 class="hentry-title">', esc_url(get_permalink())), '</h3></a>');
			else
				the_title(sprintf('<a href="%s" rel="bookmark"><h3 class="hentry-title">', esc_url(get_permalink())), '</h3></a>');

			if(get_post_type() === 'post' && !is_singular()) {
				echo '<div class="hentry-meta">';
					fwuelzen_entry_header();
				echo '</div>';
			}
		?>
	</header>

	<?php if(has_post_thumbnail()): ?>
		<div class="hentry-thumbnail">
			<?php if(!is_singular()): ?>
				<a href="<?=get_the_permalink()?>">
					<?php the_post_thumbnail('fwuelzen-post-image'); ?>
				</a>
			<?php
			else:
				the_post_thumbnail('fwuelzen-featured-image');
			endif; ?>
		</div>
	<?php endif; ?>

	<div class="hentry-content">
		<?php
			if(!is_single()) {
				the_excerpt();
			} else {
				the_content();
				wp_link_pages();
			}
		?>
	</div>

	<footer class="hentry-footer hentry-meta">
		<?php fwuelzen_entry_footer(); ?>
	</footer>
</article>
