<?php
# @Author: Kai Preuß <monster010>
# @Date:   27.05.2021
# @Email:  info@monster010.de
# @Filename: index.php
# @Last modified by:   Kai Preuß
# @Last modified time: 07.07.2021 11:44:37

get_header();
?>
<div class="container">
	<div class="row">
		<?php if(!wp_is_mobile()): ?>
			<?php get_sidebar('left'); ?>
		<?php endif; ?>

		<div class="content-area col-12 col-lg-6 col-xl-7" id="content-wrapper">
			<main class="site-content" id="site-content" role="main">
				<?php
					breadcrumb_trail();

					while (have_posts()) {
						the_post();
						get_template_part('views/posts/content', get_post_type() === 'einsatz' ? 'einsatz' : get_post_format());

						if(is_singular('post')) {
							the_post_navigation([
								'prev_text' => '<span aria-hidden="true" class="meta-nav"><i class="fas fa-angle-left"></i> '.__('Previous Post', fwuelzen_textdomain).'</span> <span class="screen-reader-text">'.__('Previous Post:', fwuelzen_textdomain).'</span><br><span class="nav-title">%title</span>',
								'next_text' => '<span aria-hidden="true" class="meta-nav">'.__('Next Post', fwuelzen_textdomain).' <i class="fas fa-angle-right"></i></span><span class="screen-reader-text">'.__('Next Post:', fwuelzen_textdomain).'</span><br><span class="nav-title">%title</span>',
							]);
						} elseif(is_singular('einsatz')) {
							the_post_navigation([
								'prev_text' => '<span aria-hidden="true" class="meta-nav"><i class="fas fa-angle-left"></i> '.__('Previous Mission', fwuelzen_textdomain).'</span> <span class="screen-reader-text">'.__('Previous Mission:', fwuelzen_textdomain).'</span><br><span class="nav-title">%title</span>',
								'next_text' => '<span aria-hidden="true" class="meta-nav">'.__('Next Mission', fwuelzen_textdomain).' <i class="fas fa-angle-right"></i></span><span class="screen-reader-text">'.__('Next Mission:', fwuelzen_textdomain).'</span><br><span class="nav-title">%title</span>',
							]);
						}

						get_sidebar('after-singular');

						if(comments_open() || get_comments_number()) {
							echo '<hr />';
							comments_template();
						}
					}
				?>
			</main>
		</div>

		<?php get_sidebar('right'); ?>
	</div>
</div>
<?php get_footer(); ?>
