<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 */

get_header();
?>
<div class="container">
	<div class="row">
		<?php get_sidebar('left'); ?>

		<div class="content-area col-12 col-lg-6 col-xl-7" id="content-wrapper">
			<main class="site-content" id="site-content" role="main">
				<header class="page-header">
					<?php if(have_posts()): ?>
						<h5 class="page-title"><?php printf(__('Search Results for: %s', fwuelzen_textdomain), '<span>'.get_search_query().'</span>'); ?></h5>
					<?php else: ?>
						<h1 class="page-title"><?=__('Nothing found', fwuelzen_textdomain)?></h1>
					<?php endif; ?>
				</header>
				<?php
					if (have_posts()):
						while (have_posts()) {
							the_post();

							get_template_part('views/posts/content', get_post_format());
						}

						fwuelzen_the_posts_navigation();
					else:
				?>
					<p>
						<?=__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', fwuelzen_textdomain)?>
					</p>
					<?php get_search_form(); ?>
				<?php endif; ?>
			</main>
		</div>

		<?php get_sidebar('right'); ?>
	</div>
</div>
<?php get_footer(); ?>
