<?php
if(!class_exists('Walker_Comment')) return;

class FwUelzen_Comment_Walker extends Walker_Comment {

	protected function html5_comment($comment, $depth, $args) {
		$tag = ('div' === $args['style']) ? 'div' : 'li';
		$output = [];

		$output[] = '<'.$tag.' id="comment-'.$comment->comment_ID.'" '.comment_class($this->has_children ? 'parent' : '', $comment, null, false).'>';
		$output[] = '<article id="div-comment-'.$comment->comment_ID.'" class="comment-body">';

		$output[] = '<header class="comment-header">';
		$output[] = '<div class="comment-author vcard">';

		$comment_author_url = get_comment_author_url($comment);
		$comment_author = get_comment_author($comment);
		$avatar = get_avatar($comment, $args['avatar_size']);

		if(0 != $args['avatar_size']) {
			$output[] = $avatar;
		}

		$output[] = '<div class="d-flex flex-column">';

		$output[] = '<a href="'.esc_url(get_comment_link($comment, $args)).'" class="comment-anchor">';
		$comment_timestamp = sprintf(__('%1$s at %2$s o\'clock', fwuelzen_textdomain), get_comment_date('', $comment), get_comment_time());
		$output[] = '<time datetime="'.get_comment_time('c').'" title="'.$comment_timestamp.'">'.$comment_timestamp.'</time></a>';

		$output[] = sprintf(
			wp_kses(
				__('%s <span class="screen-reader-text says">says:</span>', fwuelzen_textdomain),
				[
					'span' => [
						'class' => [],
					],
				]
			),
			'<b class="fn">'.$comment_author.'</b>'
		);

		$output[] = '</div>';
		$output[] = '</div><!--comment-author-->';

		$output[] = '<div class="comment-edit">';

		if(current_user_can('edit_comment', $comment->comment_ID))
			$output[] = '<a href="'.get_edit_comment_link().'" class="edit-comment-link" title="'.__('Edit', fwuelzen_textdomain).'">'.__('Edit', fwuelzen_textdomain).' <i class="fas fa-pen"></i></a>';

		$output[] = '</div>';
		$output[] = '</header>';

		$output[] = '<div class="comment-content-container">';
		$commenter = wp_get_current_commenter();

		if($commenter['comment_author_email'])
			$moderation_note = __('Your comment is awaiting moderation.', fwuelzen_textdomain);
		else
			$moderation_note = __('Your comment is awaiting moderation. This is a preview, your comment will be visible after it has been approved.', fwuelzen_textdomain);

		if('0' == $comment->comment_approved)
			$output[] = '<p class="comment-awaiting-moderation">'.$moderation_note.'</p>';

		$output[] = '<div class="comment-content">'.get_comment_text().'</div>';

		$output[] = '<footer class="comment-meta">';
		$output[] = '<div class="comment-metadata">';

		$output[] = get_comment_reply_link(array_merge(
			$args,
			[
				'add_below' => 'div-comment',
				'depth' => $depth,
				'max_depth' => $args['max_depth'],
				'before' => '',
				'after' => '',
				'reply_text' => __('Reply', fwuelzen_textdomain).' <i class="fas fa-reply"></i>'
			]
		));

		$output[] = '</div>';
		$output[] = '</footer><!--comment-meta-->';

		$output[] = '</div>';
		$output[] = '</article>';

		echo implode('', $output);
	}
}
