<?php

/**
 *	===========================================
 *		Post Entry Header
 *	===========================================
 */
if(!function_exists('fwuelzen_entry_header')) {
	function fwuelzen_entry_header() {
		if(get_post_type() === 'post') {
			echo fwuelzen_posted_on();

			if(is_singular() && current_user_can('administrator'))
				echo fwuelzen_posted_by();
		} else {
			fwuelzen_edit_link();
		}
	}
}

/**
 *	===========================================
 *		Post Entry Footer
 *	===========================================
 */
if(!function_exists('fwuelzen_entry_footer')) {
	function fwuelzen_entry_footer() {
		if(get_post_type() === 'post') {
			fwuelzen_edit_link();
		} elseif(get_post_type() === 'page') {
			echo fwuelzen_posted_on();
		}

		if(get_post_type() === 'page' && current_user_can('administrator')) {
			echo fwuelzen_posted_by();
		}
	}
}


/**
 *	===========================================
 *		Posted on for Posts
 *	===========================================
 */
if(!function_exists('fwuelzen_posted_on')) {
	function fwuelzen_posted_on(): string {
		$time_string = '<time class="hentry-date published" datetime="%1$s">%2$s</time>';

		if(get_the_time('U') !== get_the_modified_date('U'))
			$time_string = '<time class="hentry-date updated" datetime="%3$s">%4$s</time>';

		$time_string = sprintf($time_string,
			esc_attr(get_the_date(DATE_W3C)),
			esc_html(get_the_date()),
			esc_attr(get_the_modified_date(DATE_W3C)),
			esc_html(get_the_modified_date())
		);

		return sprintf(
			'<span class="byline byline-date"><i class="far fa-calendar fa-fw"></i> <a href="%1$s" rel="bookmark">%2$s</a></span>',
			esc_url(get_permalink()),
			$time_string
		);
	}
}

/**
 *	===========================================
 *		Posted by for Posts
 *	===========================================
 */
if(!function_exists('fwuelzen_posted_by')) {
	function fwuelzen_posted_by(): string {
		return sprintf(
			'<span class="byline byline-author"><i class="far fa-user fa-fw"></i> <a href="%1$s" rel="boolmark" class="author vcard">%2$s</a></span>',
			esc_url(get_author_posts_url(get_the_author_meta('ID'))),
			esc_html(get_the_author())
		);
	}
}

/**
 *	===========================================
 *		Edit Link for Pages and Posts
 *	===========================================
 */
if(!function_exists('fwuelzen_edit_link')) {
	function fwuelzen_edit_link() {
		edit_post_link(
			__('Edit', fwuelzen_textdomain),
			'<span class="byline byline-edit"><i class="fas fa-fw fa-pen"></i> ',
			'</span>'
		);
	}
}
