<?php
/**
 * Replaces "[...]" (appended to automatically generated excerpts) with ... and
 * a 'Continue reading' link.
 */
if(!function_exists('fwuelzen_excerpt_more')) {
	function fwuelzen_excerpt_more($link): string {
		if(is_admin()) return $link;

		$link = sprintf(
			'<p class="d-flex justify-content-end">
				<a href="%1$s" class="btn btn-sm btn-secondary read-more">%2$s <i class="fas fa-angle-right"></i></a>
			</p>',
			esc_url(get_permalink()),
			__('Continue reading', fwuelzen_textdomain)
		);

		return ' &hellip; '.$link;
	}

	add_filter('excerpt_more', 'fwuelzen_excerpt_more');
}

if(!function_exists('fwuelzen_excerpt_length')) {
	function fwuelzen_excerpt_length($length) {
		return 25;
	}

	add_filter('excerpt_length', 'fwuelzen_excerpt_length');
}

if(!function_exists('fwuelzen_customlogo')) {
	function fwuelzen_customlogo($html) {
		$html = str_replace('custom-logo-link', 'site-logo-link', $html);
		$html = str_replace('custom-logo', 'site-logo', $html);

		return $html;
	}

	add_filter('get_custom_logo', 'fwuelzen_customlogo', 1);
}

if(!function_exists('fwuelzen_wp_link_pages')) {
	function fwuelzen_wp_link_pages($output, $args = '') {
		global $page, $numpages, $multipage, $more;


		$defaults = array(
			'before'           => '<nav aria-label="Page navigation"><ul class="pagination">',
			'after'            => '</ul></nav>',
			'link_before'      => '<span class="page-link">',
			'link_after'       => '</span>',
			'next_or_number'   => 'number',
			'separator'        => '',
			'nextpagelink'     => __('Next', fwuelzen_textdomain),
			'previouspagelink' => __('Previous', fwuelzen_textdomain),
			'pagelink'         => '%',
			'echo'             => 1
		);

		$params = wp_parse_args($args, $defaults);
		$r = apply_filters('wp_link_pages_args', $params);

		$output = '';

		if ($multipage) {
			if ('number' == $r['next_or_number']) {
				$output .= $r['before'];

				for($i = 1; $i <= $numpages; $i++) {
					if($page == $i) {
						$link = '<li class="page-item active">'.$r['link_before'].str_replace('%', $i, $r['pagelink']).$r['link_after'].'</li>';
					} else {
						$link = '<li class="page-item">'._wp_link_page($i).$r['link_before'].str_replace('%', $i, $r['pagelink']).$r['link_after'].'</a></li>';
					}

					$link = apply_filters('wp_link_pages_link', $link, $i);

					$output .= (1 === $i) ? ' ' : $r['separator'];
					$output .= $link;
				}

				$output .= $r['after'];
			} elseif($more) {
				$output .= $r['before'];
				$prev = $page - 1;

				if($prev > 0) {
					$link = '<li class="page-item">'._wp_link_page($prev).$r['link_before'].$r['previouspagelink'].$r['link_after'].'</a></li>';

					$output .= apply_filters('wp_link_pages_link', $link, $prev);
				}

				$next = $page + 1;

				if($next <= $numpages) {
					if ($prev) {
						$output .= $r['separator'];
					}
					$link = '<li class="page-item">'._wp_link_page($next).$r['link_before'].$r['nextpagelink'].$r['link_after'].'</a></li>';

					$output .= apply_filters('wp_link_pages_link', $link, $next);
				}

				$output .= $r['after'];
			}
		}

		return $output;
	}

	add_filter('wp_link_pages', 'fwuelzen_wp_link_pages', 10, 2);
}
