<?php
# @Author: Kai Preuß <monster010>
# @Date:   27.05.2021 09:23:13
# @Email:  info@monster010.de
# @Filename: extras.php
# @Last modified by:   monster010
# @Last modified time: 27.05.2021 09:23:25

if(!function_exists('fwuelzen_copyright')) {
	function fwuelzen_copyright() {
		$year = 2021;

		if(intval($year) == date('Y')) $copyYear = intval($year);
		elseif(intval($year) < date('Y')) $copyYear = intval($year).'-'.date('Y');
		elseif(intval($year) > date('Y')) $copyYear = intval($year);

		return sprintf('Copyright &copy; %s. Theme by <a href="https://kpreuss.de">K. Preuss</a>', $year);
	}
}

if(!function_exists('fwuelzen_the_posts_navigation')) {
	function fwuelzen_the_posts_navigation(\WP_Query $wp_query = null) {
		if($wp_query === null)
			global $wp_query;

		$pages = paginate_links([
			'base'         => str_replace( 999999999, '%#%', esc_url( get_pagenum_link( 999999999 ) ) ),
			'format'       => '?paged=%#%',
			'current'      => max( 1, get_query_var( 'paged' ) ),
			'total'        => $wp_query->max_num_pages,
			'type'         => 'array',
			'show_all'     => false,
			'end_size'     => 3,
			'mid_size'     => 1,
			'prev_next'    => true,
			'prev_text'    => sprintf('<i class="fas fa-angle-left"></i> <span class="nav-prev-text sr-only">%s</span>', __('Newer posts', fwuelzen_textdomain)),
			'next_text'    => sprintf('<span class="nav-next-text sr-only">%s</span> <i class="fas fa-angle-right"></i>', __('Older posts', fwuelzen_textdomain)),
			'add_args'     => false,
			'add_fragment' => ''
		]);

		if ( is_array( $pages ) ) {
			//$paged = ( get_query_var( 'paged' ) == 0 ) ? 1 : get_query_var( 'paged' );
			$pagination = '<nav aria-label="Page navigation" role="navigation"><ul class="pagination">';

			foreach ($pages as $page) {
				$pagination .= '<li class="page-item' . (strpos($page, 'current') !== false ? ' active' : '') . '"> ' . str_replace('page-numbers', 'page-link', $page) . '</li>';
			}

			$pagination .= '</ul></nav>';

			echo $pagination;
		}

		return null;
	}
}

if(!function_exists('fwuelzen_comment_form')) {
	function fwuelzen_comment_form($order) {
		if(true === $order || strtolower($order) === strtolower(get_option('comment_order', 'asc'))) {
			ob_start();

			$req		= get_option( 'require_name_email' );
			$html_req	= ( $req ? ' required="required"' : '' );
			$aria_req	= ($req ? ' aria-required="true"' : '');

			$commenter	= wp_get_current_commenter();

			$comments_arg = [
				'title_reply'	=> null,
				'fields'		=> [
					'author'	=> '<div class="mb-3">
						<label for="author" class="col-form-label">'.__('Name').($req ? ' <span class="text-danger"> *</span>' : '').'</label>
						<div>
							<input id="author" name="author" class="form-control" type="text" maxlength="100" size="30"'.$aria_req.$html_req.' value="'.$commenter['comment_author'].'">
						</div>
					</div>',
					'email'		=> '<div class="mb-3">
						<label for="email" class="col-form-label">'.__('Email').($req ? ' <span class="text-danger"> *</span>' : '').'</label>
						<div>
							<input id="email" name="email" class="form-control" type="email" maxlength="100" size="30"'.$aria_req.$html_req.' value="'.$commenter['comment_author_email'].'">
						</div>
					</div>',
					'url'		=> '<div class="mb-3">
						<label for="url" class="col-form-label">'.__('Website').'</label>
						<div>
							<input id="url" name="url" class="form-control" type="url" maxlength="200" size="30" value="'.$commenter['comment_author_url'].'">
						</div>
					</div>',
					'cookies'	=> '<div class="form-check mb-3">
						<input type="checkbox" class="form-check-input" id="wp-comment-cookies-consent" name="wp-comment-cookies-consent">
						<label class="form-check-label" for="wp-comment-cookies-consent">' . __( 'Save my name, email, and website in this browser for the next time I comment.' ) . '</label>
					</div>'
				],

				'comment_field'	=> '<div class="mb-3">
					<label for="comment" class="col-form-label">' . __( 'Comment' ) . ' <span class="text-danger"> *</span></label>
					<div>
						<textarea id="comment" class="form-control" name="comment" cols="45" rows="8" maxlength="65525" required="required" aria-required="true"></textarea>
					</div>
					<span id="d3" class="text-danger"></span>
				</div>',

				'class_submit'	=> 'btn btn-theme',
				'submit_field'	=> '<div class="mb-3 text-center">%1$s %2$s</div>',
				'submit_button'	=> '<button type="submit" id="%2$s" name="%1$s" class="%3$s">%4$s <i class="fas fa-comment-dots"></i></button>'
			];

			comment_form($comments_arg);

			return str_replace('class="comment-form"', 'class="comment-form" name="commentForm" onsubmit="return validateForm();"', ob_get_clean());
		}
	}
}

if(!function_exists('fwuelzen_get_discussion_data')) {
	function fwuelzen_get_discussion_data(): ?object {
		global $discussion, $post_id;

		$current_post_id = get_the_ID();
		if($current_post_id === $post_id)
			return $discussion;
		else
			$post_id = $current_post_id;

		$comments = get_comments([
			'post_id'	=> $current_post_id,
			'orderby'	=> 'comment_date_gmt',
			'order'		=> get_option('comment_order', 'asc'),
			'status'	=> 'approve',
			'number'	=> 20
		]);

		$authors = [];
		foreach($comments as $comment) {
			$authors[] = ((int)$comment->user_id > 0) ? (int) $comment->user_id : $comment->comment_author_email;
		}

		$authors = array_unique($authors);
		$discussion = (object) [
			'authors'	=> array_slice($authors, 0, 6),
			'responses'	=> get_comments_number($current_post_id)
		];

		return $discussion;
	}
}

if(!function_exists('fwuelzen_get_comment_avatar_size')) {
	function fwuelzen_get_comment_avatar_size(): int {
		return 48;
	}
}
