<?php
# @Author: Kai Preuß <monster010>
# @Date:   27.05.2021 07:10:50
# @Email:  info@monster010.de
# @Filename: functions.php
# @Last modified by:   monster010
# @Last modified time: 27.05.2021 09:20:09

// Define Theme Textdomain
define('fwuelzen_textdomain', 'fwuelzen');

// Remove wordpress version tag
remove_action('wp_head', 'wp_generator');

/**
 * Load custom walker
 */
require_once get_template_directory().'/include/walker/navwalker.php';
require_once get_template_directory().'/include/walker/breadcrumb.php';
require_once get_template_directory().'/include/walker/commentwalker.php';

require_once get_template_directory().'/include/extras.php';
require_once get_template_directory().'/include/filters.php';
require_once get_template_directory().'/include/tags.php';

if (!function_exists('fwuelzen_setup')) {
	function fwuelzen_setup() {
		load_theme_textdomain(fwuelzen_textdomain, get_template_directory().'/languages');

		// Add default posts and comments RSS feed links to head.
		add_theme_support('automatic-feed-links');

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support('title-tag');

		add_theme_support('breadcrumb-trail');

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support('post-thumbnails');

		add_image_size('fwuelzen-featured-image', 1920, 1080, true);
		add_image_size('fwuelzen-post-image', 1080, 195, true);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			[
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style',
			]
		);

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://wordpress.org/support/article/post-formats/
		 */
		add_theme_support(
			'post-formats',
			[
				'aside',
				'image',
				'video',
				'quote',
				'link',
				'audio',
			]
		);

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 500,
				'width'       => 1320,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support('customize-selective-refresh-widgets');

		// Load default block styles.
		add_theme_support('wp-block-styles');

		// Add support for responsive embeds.
		add_theme_support('responsive-embeds');

		// This theme uses wp_nav_menu() in one location
		register_nav_menus([
			'primary' => __('Main Menu', fwuelzen_textdomain),
			'footer-menu' => __('Footer Menu', fwuelzen_textdomain),
		]);
	}

	add_action('after_setup_theme', 'fwuelzen_setup');
}

if (!function_exists('fwuelzen_scripts')) {
	function fwuelzen_scripts() {
		wp_enqueue_style(fwuelzen_textdomain.'-style', get_template_directory_uri().'/assets/css/app.min.css');

		// Overwrite the wordpress default jquery
		wp_enqueue_script('jquery', get_template_directory_uri().'/assets/js/jquery-3.5.1.min.js', [], '3.5.1', true);

		wp_enqueue_script('bootstrap', get_template_directory_uri().'/assets/js/bootstrap.bundle.js', ['jquery'], 'v5.0.0', true);
		wp_enqueue_script(fwuelzen_textdomain.'-script', get_template_directory_uri().'/assets/js/app.min.js', ['jquery'], true);
	}

	add_action('wp_enqueue_scripts', 'fwuelzen_scripts');
}

if(!function_exists('fwuelzen_remove_notneeded')) {
	function fwuelzen_remove_notneeded() {
		// Remove FontAwesome from einsatzverwaltung
		wp_dequeue_style('font-awesome');
	}

	add_action('wp_enqueue_scripts', 'fwuelzen_remove_notneeded', 11);
}

if (!function_exists('fwuelzen_widgets_init')) {
	function fwuelzen_widgets_init() {
		register_sidebar([
			'id'			=> 'sidebar-left',
			'name'			=> __('Left Sidebar', fwuelzen_textdomain),
			'description'	=> __('Add widgets here to appear in your sidebar on blog posts and archive pages.', fwuelzen_textdomain),
			'before_widget'	=> '<section id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</section>',
			'before_title'	=> '<h4 class="widget-title">',
			'after_title'	=> '</h4>'
		]);

		register_sidebar([
			'id'			=> 'sidebar-right',
			'name'			=> __('Right Sidebar', fwuelzen_textdomain),
			'description'	=> __('Add widgets here to appear in your sidebar on blog posts and archive pages.', fwuelzen_textdomain),
			'before_widget'	=> '<section id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</section>',
			'before_title'	=> '<h4 class="widget-title">',
			'after_title'	=> '</h4>'
		]);

		register_sidebar([
			'id'			=> 'after-singular',
			'name'			=> __('After Singular Sidebar', fwuelzen_textdomain),
			'description'	=> __('Add widgets here to appear in your sidebar on blog posts and archive pages.', fwuelzen_textdomain),
			'before_widget'	=> '<section id="%1$s" class="widget %2$s">',
			'after_widget'	=> '</section>',
			'before_title'	=> '<h4 class="widget-title">',
			'after_title'	=> '</h4>'
		]);
	}

	add_action('widgets_init', 'fwuelzen_widgets_init');
}


/**
 * Add a pingback url auto-discovery header for single posts, pages or attachments.
 */
if (!function_exists('fwuelzen_pingback_header')) {
	function fwuelzen_pingback_header() {
		if (is_singular() && pings_open()) {
			echo '<link rel="pingback" href="'.esc_url(get_bloginfo('pingback_url')).'" />';
		}
	}

	add_action('wp_head', 'fwuelzen_pingback_header');
}


if (!function_exists('fwuelzen_navbar_main')) {
	function fwuelzen_navbar_main() {
		wp_nav_menu([
			'theme_location'	=> 'primary',
			'depth'				=> 5,
			'container'			=> 'div',
			'container_class'	=> 'collapse navbar-collapse',
			'container_id'		=> 'navbarMainContent',
			'menu_class'		=> 'navbar-nav me-auto mb-2 mb-lg-0',
			'fallback_cb'		=> 'WP_Bootstrap_Navwalker::fallback',
			'walker'			=> new WP_Bootstrap_Navwalker()
		]);
	}
}

if(!function_exists('fwuelzen_breadcrumb_trail')) {
	function fwuelzen_breadcrumb_trail($args) {
		$args['before'] = '';
		$args['separator'] = '&nbsp; / &nbsp;';
		$args['front_page'] = false;
		$args['show_browse'] = false;

		return $args;
	}

	add_filter('breadcrumb_trail_args', 'fwuelzen_breadcrumb_trail');
}

if(!function_exists('fwuelzen_unique_id')) {
	function fwuelzen_unique_id($prefix = ''): string {
		static $id_counter = 0;

		if(function_exists('wp_unique_id'))
			return wp_unique_id($prefix);

		return $prefix.(string)++$id_counter;
	}
}
