<?php
if(post_password_required()) return;

$discussion = fwuelzen_get_discussion_data();
?>
<div id="comments-container" class="<?=comments_open() ? 'comments-area' : 'comments-area comments-closed'?>">
	<div class="<?=$discussion->responses > 0 ? 'comments-title-wrap' : 'comments-title-wrap no-response'?>">
		<h2 class="comments-title">
			<?php
				if(comments_open()) {
					if(have_comments()) {
						_e('Join the Conversation', fwuelzen_textdomain);
					} else {
						_e('Leave a comment', fwuelzen_textdomain);
					}
				} else {
					if($discussion->responses == '1') {
						printf(_x('One reply on &ldquo;%s&rdquo;', 'comments title', fwuelzen_textdomain), get_the_title());
					} else {
						printf(
							_nx(
								'%1$s reply on &ldquo;%s&rdquo;',
								'%1$s replies on &ldquo;%2$s&rdquo;',
								$discussion->responses,
								'comments title',
								fwuelzen_textdomain
							),
							number_format_i18n($discussion->responses),
							get_the_title()
						);
					}
				}
			?>
		</h2>
	</div>

	<?php
		if(have_comments()):
			if(comments_open()) {
				fwuelzen_comment_form('desc');
			}
	?>

	<ul class="comment-list">
		<?php wp_list_comments([
			'walker'			=> new FwUelzen_Comment_Walker(),
			'avatar_size'		=> fwuelzen_get_comment_avatar_size(),
			'short_ping'		=> true
		]); ?>
	</ul>

		<?php if(comments_open() && strtolower(get_option('comment_order', 'asc') === 'asc')): ?>
			<hr />
			<div class="comment-form-flex">
				<h2 class="comments-title" aria-hidden="true"><?=__('Leave a comment', fwuelzen_textdomain)?></h2>
				<?=fwuelzen_comment_form('asc')?>
			</div>
		<?php endif; ?>
	<?php
		else:
			echo fwuelzen_comment_form(true);
		endif;
	?>
</div>

<script type="text/javascript">
	function validateForm() {
		var form = document.forms.commentForm,
			x = form.author.value,
			y = form.email.value,
			z = form.comment.value,
			flag = true,
			d1 = document.getElementById("d1"),
			d2 = docuemtn.getElementById("d2"),
			d3 = document.getElementById("d3");

		if(x === null || x === "") {
			d1.innerHTML = "<?=__('Name is required', fwuelzen_textdomain)?>";
			flag = false;
		} else {
			d1.innerHTML = ""
		}

		if(y === null || y === "") {
			d2.innerHTML = "<?=__('Email is required', fwuelzen_textdomain)?>";
			flag = false;
		} else {
			d2.innerHTML = ""
		}

		if(z === null || z === "") {
			d3.innerHTML = "<?=__('Comment is required', fwuelzen_textdomain)?>";
			flag = false;
		} else {
			d3.innerHTML = ""
		}

		return flag;
	}
</script>
