<?php
# @Author: Kai Preuß <monster010>
# @Date:   27.05.2021 06:28:39
# @Email:  info@monster010.de
# @Filename: header.php
# @Last modified by:   monster010
# @Last modified time: 27.05.2021 08:38:02
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?=get_bloginfo('charset')?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

		<link rel="profile" href="http://gmpg.org/xfn/11">

		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<?php wp_body_open(); ?>

		<div id="wrapper" class="site-wrapper">
			<header class="site-header" id="masterhead" role="banner">
				<div class="container">
					<?php if (has_custom_logo()): ?>
						<?php the_custom_logo(); ?>
					<?php else: ?>
						<a href="<?=esc_attr(home_url('/'))?>" class="page-brand">
							<?=esc_attr(get_bloginfo('name', 'display'))?>
							<small><?=esc_attr(get_bloginfo('description', 'display'))?></small>
						</a>
					<?php endif; ?>

					<nav class="navbar navbar-main navbar-expand-lg navbar-light" id="navbarMain">
						<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMainContent" aria-controls="navbarMainContent" aria-expanded="false" aria-label="Toggle navigation">
							<span class="navbar-toggler-icon"></span>
						</button>

						<?php fwuelzen_navbar_main(); ?>
					</nav>
				</div>
			</header>
