<?php
# @Author: Kai Preuß <monster010>
# @Date:   27.05.2021
# @Email:  info@monster010.de
# @Filename: index.php
# @Last modified by:   Kai Preuß
# @Last modified time: 07.07.2021 11:37:08

get_header();
?>
<div class="container">
	<div class="row">
		<?php if(!wp_is_mobile()): ?>
			<?php get_sidebar('left'); ?>
		<?php endif; ?>
		
		<div class="content-area col-12 col-lg-6 col-xl-7" id="content-wrapper">
			<main class="site-content" id="site-content" role="main">
				<?php
					breadcrumb_trail();

					// Zeigt Links zu allen Jahresarchiven mit Einsatzberichten an
					echo '<p class="w-100 text-center mt-3">' . do_shortcode( '[einsatzjahre]' ) . '</p>';

					if (have_posts()) {
						if ( is_year() ) {
							$shownYear = get_query_var( 'year' );
							echo do_shortcode( '[einsatzliste jahr=' . esc_html( $shownYear ) . ' options=noHeading]' );
						} else {
							echo do_shortcode( '[einsatzliste options=noHeading]' );
						}
					} else {
						get_template_part('views/posts/content', 'none');
					}

					// Zeigt Links zu allen Jahresarchiven mit Einsatzberichten an
					echo '<p class="w-100 text-center mt-3">' . do_shortcode( '[einsatzjahre]' ) . '</p>';
				?>
			</main>
		</div>

		<?php get_sidebar('right'); ?>
	</div>
</div>
<?php get_footer(); ?>
